/*
    epple2
    Copyright (C) 2008 by Christopher A. Mosher <cmosher01@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY, without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#include "filterchroma.h"

/*
    Generated by the utility at http://www-users.cs.york.ac.uk/~fisher/mkfilter
    2nd order band-pass Butterworth filters (sample rate 14318182 Hz)
*/



/*
    pass 2079545 Hz through 5079545 Hz.
*/

#define GAINI 4.501156488e+00

FilterChromaI::FilterChromaI() {
    xv[0]=xv[1]=xv[2]=xv[3]=xv[4]=0;
    yv[0]=yv[1]=yv[2]=yv[3]=yv[4]=0;
}

FilterChromaI::~FilterChromaI() {
}

double FilterChromaI::next(const double v) {
    xv[0] = xv[1]; xv[1] = xv[2]; xv[2] = xv[3]; xv[3] = xv[4];
    xv[4] = v / GAINI;
    yv[0] = yv[1]; yv[1] = yv[2]; yv[2] = yv[3]; yv[3] = yv[4];
    yv[4] =   (xv[0] + xv[4]) - 2 * xv[2]
        + ( -0.1873928488 * yv[0]) + (  0.0000001868 * yv[1])
        + ( -0.2987323434 * yv[2]) + (  0.0000006376 * yv[3]);
    return yv[4];
}




/*
    pass 2979545 Hz through 4179545 Hz.
*/

#define GAINQ 2.000943914e+01

FilterChromaQ::FilterChromaQ() {
    xv[0]=xv[1]=xv[2]=xv[3]=xv[4]=0;
    yv[0]=yv[1]=yv[2]=yv[3]=yv[4]=0;
}

FilterChromaQ::~FilterChromaQ() {
}

double FilterChromaQ::next(const double v) {
    xv[0] = xv[1]; xv[1] = xv[2]; xv[2] = xv[3]; xv[3] = xv[4];
            xv[4] = v / GAINQ;
            yv[0] = yv[1]; yv[1] = yv[2]; yv[2] = yv[3]; yv[3] = yv[4];
            yv[4] =   (xv[0] + xv[4]) - 2 * xv[2]
                         + ( -0.4755965671 * yv[0]) + (  0.0000005060 * yv[1])
                         + ( -1.2756909139 * yv[2]) + (  0.0000007444 * yv[3]);
            return yv[4];
}
